#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	
 
	/// <summary>
	/// Summary description for PatientRecordReport.
	/// </summary>
	[TestFixture]
	public class BOL_PatientRecordReport : BaseTest 
	{
		
		private BOL.PatientRecordReport _report;
		private Guid _patientGuid;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			this._report = new BOL.PatientRecordReport();
			this._report.SetInitialBrokenRules("DlgPatientRecordReportCriteria");
			
			if (this.RefreshData)
			{
				string sb = "SELECT TOP 1 "+TABLES.Patient.PatientGuid+" FROM Patient ORDER BY "+TABLES.Patient.LastUpdateDate+Common.Utility.DescSortOrderSuffix;

				this._patientGuid = DataCreator.GetRecordGuid(sb.ToString());

				this.RefreshData = false;
			}
		}	

#region constructors

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(_report != null);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void Ctor_Fail()
		{
		}


#endregion

#region properties

		[Test]
		public void IncludePatientDemographics_Get()
		{
			this._report.ParameterRow["IncludePatientDemographics"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientDemographics);
			//
			this._report.ParameterRow["IncludePatientDemographics"] = true;
			Assert.IsTrue(_report.IncludePatientDemographics);
		}

		[Test]
		public void IncludePatientDemographics_Pass()
		{
			_report.IncludePatientDemographics = true;
			Assert.IsTrue(_report.IncludePatientDemographics);
		}

		[Test]
		public void IncludePatientDemographics_Fail()
		{
			_report.IncludePatientDemographics = true;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientDemographics = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientTransfusionRequirements_Get()
		{
			this._report.ParameterRow["IncludePatientTransfusionRequirements"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientTransfusionRequirements);
			//
			this._report.ParameterRow["IncludePatientTransfusionRequirements"] = true;
			Assert.IsTrue(_report.IncludePatientTransfusionRequirements);
		}

		[Test]
		public void IncludePatientTransfusionRequirements_Pass()
		{
			_report.IncludePatientTransfusionRequirements = true;
			Assert.IsTrue(_report.IncludePatientTransfusionRequirements);
		}

		[Test]
		public void IncludePatientTransfusionRequirements_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = true;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientTransfusionRequirements = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientTesting_Get()
		{
			this._report.ParameterRow["IncludePatientTesting"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientTesting);
			//
			this._report.ParameterRow["IncludePatientTesting"] = true;
			Assert.IsTrue(_report.IncludePatientTesting);
		}

		[Test]
		public void IncludePatientTesting_Pass()
		{
			_report.IncludePatientTesting = true;
			Assert.IsTrue(_report.IncludePatientTesting);
		}

		[Test]
		public void IncludePatientTesting_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = true;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientTesting = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientUnitAssignmentss_Get()
		{
			this._report.ParameterRow["IncludePatientUnitAssignments"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientUnitAssignments);
			//
			this._report.ParameterRow["IncludePatientUnitAssignments"] = true;
			Assert.IsTrue(_report.IncludePatientUnitAssignments);
		}

		[Test]
		public void IncludePatientUnitAssignmentss_Pass()
		{
			_report.IncludePatientUnitAssignments = true;
			Assert.IsTrue(_report.IncludePatientUnitAssignments);
		}

		[Test]
		public void IncludePatientUnitAssignmentss_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = true;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientUnitAssignments = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientTransfusions_Get()
		{
			this._report.ParameterRow["IncludePatientTransfusions"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientTransfusions);
			//
			this._report.ParameterRow["IncludePatientTransfusions"] = true;
			Assert.IsTrue(_report.IncludePatientTransfusions);
		}

		[Test]
		public void IncludePatientTransfusions_Pass()
		{
			_report.IncludePatientTransfusions = true;
			Assert.IsTrue(_report.IncludePatientTransfusions);
		}

		[Test]
		public void IncludePatientTransfusions_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = true;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientTransfusions = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientSpecimens_Get()
		{
			this._report.ParameterRow["IncludePatientSpecimens"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientSpecimens);
			//
			this._report.ParameterRow["IncludePatientSpecimens"] = true;
			Assert.IsTrue(_report.IncludePatientSpecimens);
		}

		[Test]
		public void IncludePatientSpecimens_Pass()
		{
			_report.IncludePatientSpecimens = true;
			Assert.IsTrue(_report.IncludePatientSpecimens);
		}

		[Test]
		public void IncludePatientSpecimens_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = true;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientSpecimens = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientSpecialInstructions_Get()
		{
			this._report.ParameterRow["IncludePatientSpecialInstructions"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientSpecialInstructions);
			//
			this._report.ParameterRow["IncludePatientSpecialInstructions"] = true;
			Assert.IsTrue(_report.IncludePatientSpecialInstructions);
		}

		[Test]
		public void IncludePatientSpecialInstructions_Pass()
		{
			_report.IncludePatientSpecialInstructions = true;
			Assert.IsTrue(_report.IncludePatientSpecialInstructions);
		}

		[Test]
		public void IncludePatientSpecialInstructions_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = true;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientSpecialInstructions = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientTransfusionReactions_Get()
		{
			this._report.ParameterRow["IncludePatientTransfusionReactions"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientTransfusionReactions);
			//
			this._report.ParameterRow["IncludePatientTransfusionReactions"] = true;
			Assert.IsTrue(_report.IncludePatientTransfusionReactions);
		}

		[Test]
		public void IncludePatientTransfusionReactions_Pass()
		{
			_report.IncludePatientTransfusionReactions = true;
			Assert.IsTrue(_report.IncludePatientTransfusionReactions);
		}

		[Test]
		public void IncludePatientTransfusionReactions_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = false;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = true;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientTransfusionReactions = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void IncludePatientExceptionReports_Get()
		{
			this._report.ParameterRow["IncludePatientExceptionReports"] = DBNull.Value;
			Assert.IsTrue(!_report.IncludePatientExceptionReports);
			//
			this._report.ParameterRow["IncludePatientExceptionReports"] = true;
			Assert.IsTrue(_report.IncludePatientExceptionReports);
		}

		[Test]
		public void IncludePatientExceptionReports_Pass()
		{
			_report.IncludePatientExceptionReports = true;
			Assert.IsTrue(_report.IncludePatientExceptionReports);
		}

		[Test]
		public void IncludePatientExceptionReports_Fail()
		{
			_report.IncludePatientDemographics = false;
			_report.IncludePatientExceptionReports = true;
			_report.IncludePatientSpecialInstructions = false;
			_report.IncludePatientSpecimens = false;
			_report.IncludePatientTesting = false;
			_report.IncludePatientTransfusionReactions = false;
			_report.IncludePatientTransfusionRequirements = false;
			_report.IncludePatientTransfusions = false;
			_report.IncludePatientUnitAssignments = false;
			int rulesBefore = _report.BrokenRulesCount;
			//
			_report.IncludePatientExceptionReports = false;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}

		[Test]
		public void ReportCriteria_Get_Pass()
		{
			_report.IncludePatientExceptionReports = true;
			_report.PatientGuid = _patientGuid;
			Assert.IsNotNull(_report.ReportCriteria);
		}

		[Test]
		[ExpectedException(typeof(BOL.BusinessObjectException))]
		public void ReportCriteria_Get_Fail()
		{
			this._report.PatientGuid = System.Guid.Empty;
			Assert.IsNotNull(_report.ReportCriteria);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.ReadOnlyProperty )]
		public void ReportCriteria_Set()
		{
		}

		[Test]
		public void PatientGuid_Get()
		{
			_report.PatientGuid = _patientGuid;
			Assert.AreEqual(_patientGuid,_report.PatientGuid);
		}

		[Test]
		public void PatientGuid_Pass()
		{
			_report.PatientGuid = Guid.Empty;
			int rulesBefore = _report.BrokenRulesCount;
			
			_report.PatientGuid = _patientGuid;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter<rulesBefore);
		}

		[Test]
		public void PatientGuid_Fail()
		{
			_report.PatientGuid = _patientGuid;
			int rulesBefore = _report.BrokenRulesCount;
			
			_report.PatientGuid = Guid.Empty;
			int rulesAfter = _report.BrokenRulesCount;
			//
			Assert.IsTrue(rulesAfter>rulesBefore);
		}
#endregion


#region methods

		[Test]
		public void GetPatientRecordReport_Pass()
		{
			//Adding VistA converted SIs and TRs for 100% coverage
			DataTable dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			DataRow drSI = dtInsertSpecialInstructions.NewRow();
			drSI[TABLES.PatientSpecialInstruction.PatientSpecialInstructionGuid] = System.Guid.NewGuid();
			drSI[TABLES.PatientSpecialInstruction.PatientGuid] = this._patientGuid;
			drSI[TABLES.PatientSpecialInstruction.PatientSpecialInstructions] = "Unit Test 5559";
			drSI[TABLES.PatientSpecialInstruction.CreateDate] = DateTime.Now;
			drSI[TABLES.PatientSpecialInstruction.CreateUser] = Environment.UserName;
			drSI[TABLES.PatientSpecialInstruction.VistaConversionIndicator] = true;
			drSI[TABLES.PatientSpecialInstruction.DivisionCode] = UnitTestConfig.TestDivisionCode;
			drSI[TABLES.PatientSpecialInstruction.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Converted);
			drSI[TABLES.PatientSpecialInstruction.LastUpdateUser] = Environment.UserName;
			dtInsertSpecialInstructions.Rows.Add(drSI);
			//
			DataTable dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			DataRow drTR = dtInsertTransfusionRequirements.NewRow();
			drTR[TABLES.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = System.Guid.NewGuid();
			drTR[TABLES.PatientSpecialInstruction.PatientGuid] = this._patientGuid;
			drTR[TABLES.PatientTransfusionRequirement.TransfusionRequirementText] = "Irradiated cellular products";
			drTR[TABLES.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = Common.Utility.GetTransfusionCategoryCodeFromEnum( Common.TransfusionRequirementCategoryCode.ComponentRequirement );
			drTR[TABLES.PatientTransfusionRequirement.CreateDate] = DateTime.Now;
			drTR[TABLES.PatientTransfusionRequirement.CreateUser] = Environment.UserName;
			drTR[TABLES.PatientTransfusionRequirement.CreateDivisionCode] = UnitTestConfig.TestDivisionCode;
			drTR[TABLES.PatientTransfusionRequirement.VistaConversionIndicator] = true;
			drTR[TABLES.PatientTransfusionRequirement.ComponentRequirementId] = 1;
			drTR[TABLES.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Converted);
			drTR[TABLES.PatientTransfusionRequirement.LastUpdateUser] = Environment.UserName;
			drTR[TABLES.PatientTransfusion.DivisionCode] = UnitTestConfig.TestDivisionCode;
			dtInsertTransfusionRequirements.Rows.Add(drTR);
			//
			BOL.Patient.SaveSIsAndTRs(dtInsertSpecialInstructions, new DataTable(), dtInsertTransfusionRequirements, new DataTable(), Common.UpdateFunction.UnitTests);
			//
			_report.PatientGuid = _patientGuid;
			_report.IncludePatientExceptionReports = true;
			Assert.IsTrue(_report.GetPatientRecordReport().Tables[0].Rows.Count>0);
		}

		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void GetPatientRecordReport_Fail()
		{
			string dvsn = UnitTestConfig.TestDivisionCode;
			_report.PatientGuid = Guid.Empty;
			Common.LogonUser.LogonUserDivisionCode = "XXXXX";
			Assert.AreEqual(0,_report.GetPatientRecordReport().Tables[0].Rows.Count);
			//Reset division
			Common.LogonUser.LogonUserDivisionCode = dvsn;
		}

		[Test]
		public void GetPatientRecordReportCount_Pass()
		{
			_report.PatientGuid = _patientGuid;
			_report.IncludePatientExceptionReports = true;
			Assert.IsTrue(_report.GetPatientRecordReportCount()>0);
		}

		[Test]
		public void GetPatientRecordReportCount_Fail()
		{
			string dvsn = UnitTestConfig.TestDivisionCode;
			_report.PatientGuid = Guid.Empty;
			Common.LogonUser.LogonUserDivisionCode = "XXXXX";
			Assert.AreEqual(0,_report.GetPatientRecordReportCount());
			//Reset division
			Common.LogonUser.LogonUserDivisionCode = dvsn;
		}

		[Test]
		public void GenerateReport_Pass()
		{
			_report.PatientGuid = _patientGuid;
			_report.IncludePatientExceptionReports = true;
            _report.GenerateReport();
			Assert.IsNotNull(_report);
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.NoFailureConditions )]
		public void GenerateReport_Fail()
		{
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.Untestable )]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to a printer
		}

		[Test]
		[Ignore ( StandardIgnoreReasons.Untestable )]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to a printer
		}

#endregion
	}
}

#endif
